import { JwtService } from '@nestjs/jwt';
import { Repository } from 'typeorm';
import { User } from '../../entities/user.entity';
import { Customer } from '../../entities/customer.entity';
import { Vendor } from '../../entities/vendor.entity';
import { LoginDto, RegisterDto, ChangePasswordDto } from './dto';
export declare class AuthService {
    private readonly userRepo;
    private readonly customerRepo;
    private readonly vendorRepo;
    private readonly jwtService;
    constructor(userRepo: Repository<User>, customerRepo: Repository<Customer>, vendorRepo: Repository<Vendor>, jwtService: JwtService);
    login(loginDto: LoginDto, requiredRole?: string): Promise<{
        access_token: string;
        user: {
            id: number;
            email: string;
            role: string;
            customerId: number;
            vendorId: number;
        };
    }>;
    register(registerDto: RegisterDto): Promise<{
        access_token: string;
        user: {
            id: number;
            email: string;
            role: string;
        };
    }>;
    changePassword(changePasswordDto: ChangePasswordDto, userId: string): Promise<{
        message: string;
    }>;
    validateUser(email: string, password: string): Promise<any>;
    private isValidPhoneNumber;
    getUserProfile(userId: string): Promise<{
        id: number;
        email: string;
        role: string;
        isActive: boolean;
        customer: any;
        vendor: any;
        createdAt: Date;
        updatedAt: Date;
    }>;
}
